
/*----------------------------------------------------------------------------
 * Name     : radio.c
 * Purpose  : 
 * Note(s)  : 
 *----------------------------------------------------------------------------
 *----------------------------------------------------------------------------*/
#include		"main.h"
#include		"radio.h"
#include		"timer.h"
#include   		"string.h"
#include		"variable.h"

#if (SYSTEM_CLOCK == FSYS4MHZ)		
#define	CHANNEL_PERIOD_WIDTH			1250					/* SCLK=4M/16,5ms=1250*4us */
#elif (SYSTEM_CLOCK == FSYS8MHZ)
#define	CHANNEL_PERIOD_WIDTH			2500					/* SCLK=8M/16,5ms=2500*2us */
#else
#define	CHANNEL_PERIOD_WIDTH			3750					/* SCLK=12M/16,5ms=3750*1.333us */
#endif

bit radio_tx_fail;
bit	period_tm_valid;
bit	rx_payload_valid;
bit	radio_tx_success;

u8	radio_status;
u8	radio_rx_width;
u8	radio_tx_width;
u8	radio_address[5];
u8	radio_timeout_counter;
u8	radio_work_channel_idx;
u8	radio_channel_table[_HOPFreq_Num_] = {_HOP_Freq1_,_HOP_Freq2_,_HOP_Freq3_};
/*----------------------------------------------------------------------------*/
/* @brief 	: radio parameter Configure 													*
 *	@param	: m - TRUE/FALSE																	*
 *	@retval  :																						*/
/*----------------------------------------------------------------------------*/
void RadioConfigure(u8 m)
{
	BC5602LightSleepMode();
	BC5602WaitCrystalReady();
	BC5602SetDataRate(_DATARATE_);					/* data rate */
	BC5602SetCRCMode(_CRC_TYPE_);						/* CRC type */
	BC5602SetRFChannel(radio_channel_table[0]);
	BC5602SetOutputPower(_TX_POWER_);					/* TX power */
	BC5602SetIRQMode(IRQ_ALL,ENABLE);						/* enable all IRQ */
	
	if(BC5161_flearning)
		memcpy((void *)radio_address,(void *)BC5161_Pairing_Address,5);
	else
		memcpy((void *)radio_address,(void *)BC5602_message_Address,5);
	
	BC5602SetAddress(TRXADDR,radio_address);						/* set TX/RX PIPE0 address */
	BC5602ClosePipe(PIPEALL);
	if(m)
	{
		BC5602SetAddressWidth(_BC5602_ADDR_WIDTH_);					/* address width */
		BC5602SetupFeature(_BC5602_Dynamic_Payload_);				/* enable pyaload dynamic length */
		BC5602SetupDynamicPayload(_BC5602_EN_Dynamic_PIPE_);		/* enable RX PIPE0 dynamic length */
		BC5602SetAutoRetr(_Resend_,ARD_DLY500);					/* ARC repeat=0,ARD delay 500us */ 
		BC5602OpenPipe(PIPE0,ENABLE);								/* open RX PIPE0 & enable AUTO-ACK */
	}
	else
	{
		if(BC5161_flearning)	BC5602SetAddressWidth(AW_4BYTE);
		else	BC5602SetAddressWidth(_ADDR_LEN_);
		BC5602SetupFeature(_BC5161_Dynamic_Payload_);				/* disable pyaload dynamic length */		
		BC5602SetupDynamicPayload(_BC5161_EN_Dynamic_PIPE_);		/* disable RX PIPE0 dynamic length */		
		BC5602SetAutoRetr(_Resend_,ARD_DLY500);					/* ARC repeat=0,ARD delay 500us */   
		if(_PCF_EN_)
		BC5602OpenPipe(PIPE0,ENABLE);								/* open RX PIPE0 & enable AUTO-ACK */
		else
		{
			BC5602OpenPipe(PIPE0,DISABLE);							/* open RX PIPE0 & disable AUTO-ACK */
			if(BC5161_flearning)
			BC5602SetRxPayloadWidth(RX_PIPE0,_BC5161_RADIO_ADDR_WIDTH_+_BC5161_Device_ID_Width);
			else
			BC5602SetRxPayloadWidth(RX_PIPE0,_BC5161_Device_ID_Width+1);
		}
	}
	BC5602TxFIFOFlush();
	BC5602RxFIFOFlush();	
	BC5602GetClearIRQFlags();	
	BC5602CrystalSetup(_Current_mode_,_trim_value_);
	BC5602AutoCalibration();	
	RadioPeriodTmInitial((u16)CHANNEL_PERIOD_WIDTH);
	radio_work_channel_idx=0;
	RadioRxStart();	
}
/*----------------------------------------------------------------------------*/
/* @brief 	: radio parameter Configure 													*
 *	@param	: m - TRUE/FALSE																	*
 *	@retval  :																						*/
/*----------------------------------------------------------------------------*/
void RadioProcess(void)
{
	u8 sts;
	irq_status_t	irqs;
	
	if(!IRQ_STATUS)
	{
		irqs.value=BC5602ReadRegister(IRQ_STS_REGS);
		BC5602ClearIRQFlags(irqs.value);
		if(irqs.bits.rx_dr)
		{
			if(irqs.bits.rx_p_no != RX_EMPTY)
			{
				radio_rx_width=BC5602ReadRxPayloadWidth();
				BC5602ReadRxPayload(RxPayloadData,radio_rx_width);
				rx_payload_valid = TRUE;
			}
		}
		
		if(irqs.bits.tx_ds)
		{			
			radio_tx_success = TRUE;
			RadioRxStart();
		}
		
		if(irqs.bits.max_rt)
		{
			BC5602TxFIFOFlush();
			radio_timeout_counter++;
			if(radio_timeout_counter < RADIO_TX_TIMEOUT)
			{
				radio_work_channel_idx++;
				if(radio_work_channel_idx >= _HOPFreq_Num_) 
				radio_work_channel_idx=0; 
				BC5602SetRFChannel(radio_channel_table[radio_work_channel_idx]);
				BC5602WriteTxPayload(TxPayloadData,radio_tx_width);
				BC5602TriggerCE();
				while((BC5602GetOperationMode() != _TX_MODE_));
			}
			else
			{
				radio_tx_fail = TRUE;
				RadioRxStart();
			}
		}
	}
	if(period_tm_valid && (radio_status == RADIO_RX_ACTIVE))
	{
		if((BC5602GetOperationMode() == _RX_MODE_) && IRQ_STATUS)
		{		
			period_tm_valid = FALSE;
			BC5602SetupCE(~_CE_);
			BC5602RxFIFOFlush();
			radio_work_channel_idx++;
			if(radio_work_channel_idx >= _HOPFreq_Num_) radio_work_channel_idx=0; 
			irqs.value = BC5602ReadRegister(CLK_CTL1_REGS);
            BC5602WriteRegister(CLK_CTL1_REGS,irqs.value | _RST_LL_);
            BC5602WriteRegister(CLK_CTL1_REGS,irqs.value);
			BC5602SetRFChannel(radio_channel_table[radio_work_channel_idx]);
			BC5602SetupCE(_CE_);
			do
			{
				GCC_DELAY(200);					/*delay 100us*/
				sts=BC5602GetOperationMode();
				if(sts == _LIGHT_SLEEP_MODE_) 
                {
                    BC5602SetupCE(~_CE_);                            
                    irqs.value = BC5602ReadRegister(CLK_CTL1_REGS);
                    BC5602WriteRegister(CLK_CTL1_REGS,irqs.value | _RST_LL_);
                    BC5602WriteRegister(CLK_CTL1_REGS,irqs.value);
                    BC5602SetupCE(_CE_);
                }
            }
            while(sts != _RX_MODE_); 
		}
	}
}
/*----------------------------------------------------------------------------*/
/* @brief 	: radio parameter Configure 													*
 *	@param	: m - TRUE/FALSE																	*
 *	@retval  :																						*/
/*----------------------------------------------------------------------------*/
void RadioTxData(u8 len)
{
	BC5602SetupCE(~_CE_);	
	BC5602SetPrimaryMode(PRIM_PTX);
	radio_tx_width=len;
	BC5602WriteTxPayload(TxPayloadData,radio_tx_width);
	radio_timeout_counter=0;
	radio_tx_success = FALSE;	
	BC5602TriggerCE();
	while((BC5602GetOperationMode() != _TX_MODE_));
	radio_status = RADIO_TX_ACTIVE;	
}
/*----------------------------------------------------------------------------*/
/* @brief 	: radio parameter Configure 													*
 *	@param	: m - TRUE/FALSE																	*
 *	@retval  :																						*/
/*----------------------------------------------------------------------------*/
void RadioRxStart(void)
{
	BC5602SetupCE(~_CE_);
	BC5602SetPrimaryMode(PRIM_PRX);
	BC5602RxFIFOFlush();	
	period_tm_valid = FALSE;
	BC5602SetupCE(_CE_);
	while((BC5602GetOperationMode() != _RX_MODE_));
	radio_status = RADIO_RX_ACTIVE;
}
/*----------------------------------------------------------------------------*/
/*	function nameGFrequency hopping timer initialization								
	roleGhappen hopping frequency interval													
	input parametersGCHANNEL_PERIOD_WIDTH													*/
/*----------------------------------------------------------------------------*/
void RadioPeriodTmInitial(u16 period)
{
   _TMC0_ 	= 0x20;					/* stck = Fsys */
   _TMC1_ 	= 0xC1;					/* counter mode,STCCLR=Comparator A match */
   _TMAL_ 	= period & 0xFF;
   _TMAH_ 	= period >> 8;
   _TMIF_ 	= FALSE;
   _TMMFIF_ = FALSE;
	_TMIE_	= TRUE;
	_TMMFIE_	= TRUE;
   _TMON_	= TRUE;
   period_tm_valid = FALSE;
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void __attribute((interrupt(_TMISRADDR_))) RadioPeriodTmISR(void)
{
	if(_TMIF_)
	{
		_TMIF_ = FALSE;
		period_tm_valid = TRUE;
	}
}
